
// Coded by Ruchira Hasaranga (c) 2009

#include<windows.h>
#include <stdio.h>


#define MENU_SEND_TO_MADHURA 30011
#define MENU_OPEN_USING_EXPLORER 30012
#define MENU_SEND_EMAIL 30013
#define MENU_SEARCH_USING_GOOGLE 30014


bool isFilePresent(wchar_t* path)
{
	FILE *stream=0;

	_wfopen_s(&stream,path,L"r");

	if(!stream)
		return false;

	fclose(stream);
	return true;

}

void runMadhuraDictionary(HWND hwnd)
{
	HKEY hkey;
	DWORD lpdwDisposition,lpcbData,lpData;

	lpcbData=MAX_PATH;
	static wchar_t data[MAX_PATH];

	RegCreateKeyEx(HKEY_LOCAL_MACHINE,L"Software\\Microsoft\\Windows\\CurrentVersion",
		0,0,REG_OPTION_NON_VOLATILE,KEY_QUERY_VALUE,0,&hkey,&lpdwDisposition);

	if(hkey==0) // open failed!
	{
		return ;
	}

	if(RegQueryValueEx(hkey,L"ProgramFilesDir",NULL,&lpData,(BYTE*)data,&lpcbData)==ERROR_SUCCESS)
	{	
		wcsncat_s(data,MAX_PATH,L"\\MADHURA Dictionary\\MADHURA.exe",lstrlen(L"\\MADHURA Dictionary\\MADHURA.exe"));
		
		if(isFilePresent(data))
		{
			ShellExecute(0,L"open",data,0,0,SW_SHOW);
		}else
		{
			MessageBox(GetParent(hwnd),L"Cannot find Madhura Dictionary!",L"Error",MB_ICONERROR);
		}
		
	}

	RegCloseKey(hkey);
	
}

void runExplorer(wchar_t* text)
{
	ShellExecute(0,L"open",text,0,0,SW_SHOW);
}

void sendEmail(wchar_t* address)
{

}

LRESULT CALLBACK LocalEdit_WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{

	WNDPROC lpfnEditClassProc=(WNDPROC)GetProp(hwnd,L"SX_WNDPROC");

	if(msg==WM_MENUSELECT)
	{
		HMENU hmenu=(HMENU)lParam;
		if(hmenu)
		{
			HMENU insertedMenu=(HMENU)GetProp(hwnd,L"SX");
			
			if(!insertedMenu)
			{
				SetProp(hwnd,L"SX",(HANDLE)hmenu);
				insertedMenu=hmenu;
			}

			if(insertedMenu==hmenu)
			{	
				MENUITEMINFO mii;
				ZeroMemory(&mii, sizeof(mii));
				mii.cbSize=sizeof(MENUITEMINFO);

				if(!GetMenuItemInfo(hmenu,MENU_SEND_TO_MADHURA,FALSE,&mii))
				{
					int    uBegSel, uEndSel; 
					SendMessage (hwnd, EM_GETSEL,(WPARAM)&uBegSel, (LPARAM)&uEndSel);
					bool empty=(uBegSel == uEndSel)? true:false;
					UINT flags=empty?MF_BYPOSITION|MF_STRING|MF_DISABLED|MF_GRAYED:MF_BYPOSITION|MF_STRING;

					InsertMenu(hmenu,0xFFFFFFFF,MF_BYPOSITION|MF_SEPARATOR,0,0);
					InsertMenu(hmenu,0xFFFFFFFF,flags,MENU_SEND_TO_MADHURA,L"Send To Madhura Dictionary");
					InsertMenu(hmenu,0xFFFFFFFF,flags,MENU_SEARCH_USING_GOOGLE,L"Search Using Google");
					InsertMenu(hmenu,0xFFFFFFFF,flags,MENU_OPEN_USING_EXPLORER,L"Open Using Explorer");
					InsertMenu(hmenu,0xFFFFFFFF,flags,MENU_SEND_EMAIL,L"Send an e-mail");
				}
			}
		}
		
	}else if(msg==WM_CONTEXTMENU)
	{
		RemoveProp(hwnd,L"SX");

	}else if(msg==WM_DESTROY)
	{
		RemoveProp(hwnd,L"SX");
		RemoveProp(hwnd,L"SX_WNDPROC");
		SetWindowLong(hwnd, GWL_WNDPROC, (DWORD) lpfnEditClassProc);
	}else if(msg==MENU_SEND_TO_MADHURA)
	{
		int    uBegSel, uEndSel; 
		SendMessage (hwnd, EM_GETSEL,(WPARAM)&uBegSel, (LPARAM)&uEndSel); 
		if (uBegSel != uEndSel)
		{
			int textSize=uEndSel-uBegSel;

			if(textSize>=512)
			{
				MessageBox(GetParent(hwnd),L"Selected text is too big...",L"Error",MB_ICONERROR);
				return 0;
			}

			SendMessage(hwnd,WM_COPY,0,0);
			if(!FindWindow(L"ThunderRT6FormDC",L"MADHURA English-Sinhala Dictionary ")) 
				runMadhuraDictionary(hwnd);

		}
		
		return 0;
	}else if(msg==MENU_OPEN_USING_EXPLORER)
	{
		int    uBegSel, uEndSel; 
		SendMessage (hwnd, EM_GETSEL,(WPARAM)&uBegSel, (LPARAM)&uEndSel); 
		if (uBegSel != uEndSel)
		{
			int textSize=uEndSel-uBegSel;

			if(textSize>=512)
			{
				MessageBox(GetParent(hwnd),L"Selected text is too big...",L"Error",MB_ICONERROR);
				return 0;
			}

			int buffSize=(int)SendMessage(hwnd,WM_GETTEXTLENGTH,0,0);

			wchar_t *buff1=new wchar_t[buffSize+2];
			wchar_t *buff2=new wchar_t[textSize+2];

			GetWindowText(hwnd,buff1,buffSize+2);

			int i;
			for(i=0;i<textSize;i++)
				buff2[i]=buff1[(uBegSel+i)];

			buff2[i]=0; // null terminated string!

			runExplorer(buff2);

			delete buff1;
			delete buff2;

		}
		
		return 0;
	}else if(msg==MENU_SEND_EMAIL)
	{
		int    uBegSel, uEndSel; 
		SendMessage (hwnd, EM_GETSEL,(WPARAM)&uBegSel, (LPARAM)&uEndSel); 
		if (uBegSel != uEndSel)
		{
			int textSize=uEndSel-uBegSel;

			if(textSize>=512)
			{
				MessageBox(GetParent(hwnd),L"Selected text is too big...",L"Error",MB_ICONERROR);
				return 0;
			}

			int buffSize=(int)SendMessage(hwnd,WM_GETTEXTLENGTH,0,0);

			wchar_t *buff1=new wchar_t[buffSize+2];
			wchar_t *buff2=new wchar_t[textSize+2];

			GetWindowText(hwnd,buff1,buffSize+2);

			int i;
			for(i=0;i<(uEndSel-uBegSel);i++)
				buff2[i]=buff1[(uBegSel+i)];

			buff2[i]=0;

			wchar_t *buff3=new wchar_t[textSize+4+lstrlen(L"mailto:%s")];

			swprintf(buff3,L"mailto:%s",buff2);
			
			runExplorer(buff3);

			delete buff1;
			delete buff2;
			delete buff3;
		}
		
		return 0;
	}else if(msg==MENU_SEARCH_USING_GOOGLE)
	{
		int    uBegSel, uEndSel; 
		SendMessage (hwnd, EM_GETSEL,(WPARAM)&uBegSel, (LPARAM)&uEndSel); 
		if (uBegSel != uEndSel)
		{
			int textSize=uEndSel-uBegSel;

			if(textSize>=512)
			{
				MessageBox(GetParent(hwnd),L"Selected text is too big...",L"Error",MB_ICONERROR);
				return 0;
			}

			int buffSize=(int)SendMessage(hwnd,WM_GETTEXTLENGTH,0,0);

			wchar_t *buff1=new wchar_t[buffSize+2];
			wchar_t *buff2=new wchar_t[textSize+2];

			GetWindowText(hwnd,buff1,buffSize+2);

			int i;
			for(i=0;i<(uEndSel-uBegSel);i++)
				buff2[i]=buff1[(uBegSel+i)];

			buff2[i]=0;

			wchar_t *buff3=new wchar_t[textSize+4+lstrlen(L"http://www.google.com/search?&q=%s")];

			swprintf(buff3,L"http://www.google.com/search?&q=%s",buff2);
			
			runExplorer(buff3);

			delete buff1;
			delete buff2;
			delete buff3;
		}
		
		return 0;
	}

	if(lpfnEditClassProc)
	 return CallWindowProc(lpfnEditClassProc, hwnd, msg, wParam, lParam);
	else
		return 0; // oops!
}


HHOOK wnd_hook;

LRESULT CALLBACK CBTProc(int nCode,WPARAM wParam,LPARAM lParam)
{

	if(nCode < 0)
        return CallNextHookEx(wnd_hook, nCode, wParam, lParam);

	if(nCode==HCBT_CREATEWND){
		HWND hwnd=(HWND)wParam;

		if(hwnd)
		{
			wchar_t className[32];
			if(GetClassName(hwnd,className,32))
			{
				if(wcscmp(className,L"Edit")==0)
				{
					WNDPROC lpfnEditClassProc = (WNDPROC)SetWindowLong(hwnd,GWL_WNDPROC,(DWORD) LocalEdit_WndProc);
					SetProp(hwnd,L"SX_WNDPROC",(HANDLE)lpfnEditClassProc);
				}
			}
		}
		
	}

	// Call the next hook, if there is one
    return CallNextHookEx(wnd_hook, nCode, wParam, lParam);

}


extern "C" _declspec(dllexport) void installHook()
{
	wnd_hook=SetWindowsHookEx(WH_CBT,&CBTProc,GetModuleHandle(L"SelectX.dll"),0);
}

extern "C" _declspec(dllexport) void uninstallHook()
{
	UnhookWindowsHookEx(wnd_hook);
}


BOOL WINAPI DllMain(HINSTANCE hinstDLL,DWORD fdwReason,LPVOID lpvReserved)
{

	return true;

}

extern "C" __declspec(dllexport) void about()
{
	MessageBox(0,L"Coded by Ruchira Hasaranga\nruchira66@gmail.com",L"about",MB_OK);
}
 
